#include "customgui_base.h"



void FillBaseCustomGui(BaseCustomGuiLib &basecustomguilib)
{
	basecustomguilib.Redraw								= &iBaseCustomGui::CustomGuiRedraw					;
	basecustomguilib.LayoutChanged				= &iBaseCustomGui::CustomGuiLayoutChanged		;
	basecustomguilib.GetWidth							= &iBaseCustomGui::CustomGuiWidth						;
	basecustomguilib.GetHeight						= &iBaseCustomGui::CustomGuiHeight					;
	basecustomguilib.Activate							= &iBaseCustomGui::CustomGuiActivate				;
	basecustomguilib.SetDefaultForResEdit	= &iBaseCustomGui::SetDefaultForResEdit			;
	basecustomguilib.SetData							= &iBaseCustomGui::SetData									;
	basecustomguilib.GetData							= &iBaseCustomGui::GetData									;
	basecustomguilib.SetLayoutMode				= &iBaseCustomGui::SetLayoutMode						;
	basecustomguilib.GetLayoutMode				= &iBaseCustomGui::GetLayoutMode						;
	basecustomguilib.SupportLayoutSwitch	= &iBaseCustomGui::SupportLayoutSwitch			;
}

LONG _BaseCustomGui::GetWidth(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,GetWidth),NULL);
	if (!lib || !lib->GetWidth) return FALSE;
	return (((iBaseCustomGui*)this)->*(lib->GetWidth))();
}

LONG _BaseCustomGui::GetHeight(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,GetHeight),NULL);
	if (!lib || !lib->GetHeight) return FALSE;
	return (((iBaseCustomGui*)this)->*(lib->GetHeight))();
}

void _BaseCustomGui::Redraw(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,Redraw),NULL);
	if (!lib || !lib->Redraw) return;
	(((iBaseCustomGui*)this)->*(lib->Redraw))();
}

Bool _BaseCustomGui::LayoutChanged(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,LayoutChanged),NULL);
	if (!lib || !lib->LayoutChanged) return FALSE;
	return (((iBaseCustomGui*)this)->*(lib->LayoutChanged))();
}

Bool _BaseCustomGui::Activate(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,Activate),NULL);
	if (!lib || !lib->Activate) return FALSE;
	return (((iBaseCustomGui*)this)->*(lib->Activate))();
}

Bool _BaseCustomGui::SetDefaultForResEdit(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,SetDefaultForResEdit),NULL);
	if (!lib || !lib->SetDefaultForResEdit) return FALSE;
	return (((iBaseCustomGui*)this)->*(lib->SetDefaultForResEdit))();
}

Bool _BaseCustomGui::SetData(LONG LIBRARYID,const TriState<GeData> &tristate)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,SetData),NULL);
	if (!lib || !lib->SetData) return FALSE;
	return (((iBaseCustomGui*)this)->*(lib->SetData))(tristate);
}

TriState<GeData> _BaseCustomGui::GetData(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,GetData),NULL);
	if (!lib || !lib->GetData) 
	{
		TriState<GeData> tri;
		return tri;
	}
	return (((iBaseCustomGui*)this)->*(lib->GetData))();
}

void _BaseCustomGui::SetLayoutMode(LONG LIBRARYID,LONG mode)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,SetLayoutMode),NULL);
	if (!lib || !lib->GetData) return;
	(((iBaseCustomGui*)this)->*(lib->SetLayoutMode))(mode);
}

LONG _BaseCustomGui::GetLayoutMode(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,GetLayoutMode),NULL);
	if (!lib || !lib->GetData) return 0;
	return (((iBaseCustomGui*)this)->*(lib->GetLayoutMode))();
}

Bool _BaseCustomGui::SupportLayoutSwitch(LONG LIBRARYID)
{
	BaseCustomGuiLib *lib = (BaseCustomGuiLib*)CheckLib(LIBRARYID,LIBOFFSET(BaseCustomGuiLib,SupportLayoutSwitch),NULL);
	if (!lib || !lib->GetData) return 0;
	return (((iBaseCustomGui*)this)->*(lib->SupportLayoutSwitch))();
}
